IF  not OBJECT_ID('RS_ARVMERC_EST_PED_ELTR_DEMANDA_CP_IT') IS NULL
BEGIN
	DROP TABLE  RS_ARVMERC_EST_PED_ELTR_DEMANDA_CP_IT; 
END

GO	                         
CREATE TABLE RS_ARVMERC_EST_PED_ELTR_DEMANDA_CP_IT (    CD_EMP                INT,
											CD_FILIAL             INT,
											CD_PROD               INT, 
											CD_COND_COMPRA		   INT,
											ESEG                  MONEY,
											EMAX                  MONEY,
											QTDE_MEDIAP           MONEY,
											QT_EST_PEND           MONEY,
											QT_PEND_ENT           MONEY,
											QT_EST_MTZ            MONEY,
											CD_GRP_PARAM          INT,
											CD_SIGLA              INT, 
											CD_ARV_MERC_LINHA     INT, 
											CD_FABRIC             INT, 
											VLR_PROD			   MONEY,				
											PERC_DESC			   MONEY,
											APRES_QT_CP           MONEY,
											QT_EST_LOJA		   MONEY,
											CD_USU				   INT,
				PRIMARY KEY  (CD_PROD,CD_FILIAL,CD_EMP, CD_USU));		
	
GO
 /****** Object:  StoredProcedure [dbo].[P_EST_PED_ELTR_DEMANDA_CP_IT]    Script Date: 02/11/2014 17:19:16 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PED_ELTR_DEMANDA_CP_IT]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PED_ELTR_DEMANDA_CP_IT]
GO

/****** Object:  StoredProcedure [dbo].[P_EST_PED_ELTR_DEMANDA_CP_IT]    Script Date: 02/11/2014 17:19:16 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO
 -- Versao 3073 
CREATE   PROCEDURE [dbo].[P_EST_PED_ELTR_DEMANDA_CP_IT]  @CD_EMP			INT, 
															@CD_USU			INT,
															@FILIAIS        VARCHAR(MAX),
															@PRODUTOS       VARCHAR(MAX),
															@LISTA_PRECO    VARCHAR(MAX),
															@FLAG_EST_ZERO			INT,
															@FLAG_IGNORA_VINC_FORN	INT,
															@FLAG_CONSIDERA_EST_CD	INT,
															@FLAG_CONSIDERA_FACE	INT,
															@FLAG_PERC_ACIMA		MONEY = 0,
															@PERC_ACIMA				MONEY = 0,
															@CD_CTR_DEPO			INT   = 1,  
															@FLAG_PROD_PBM			INT   = 0 AS
SET NOCOUNT ON;  

/******************************************************************************************************************/
-- PARAMETROS ACESSORIOS
/*******************************************************************************************************************/


DECLARE @CD_FILIAL_DEPOS  INT;
DECLARE @AGORA DATETIME;
DECLARE @TIPOPRODUTOCOMPRA AS INT;
DECLARE @UtilizarCincoQuartos AS INT;
DECLARE @MEDIAF_MIN AS MONEY;
  
SET @TIPOPRODUTOCOMPRA = ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG WHERE PRC_EMP_CONFIG.CD_CHAVE = 'FLAG_CONTROLE_TIPO_PRODUTO_PEDIDO_ELETRONICO'),0)
SET @UtilizarCincoQuartos = ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG WHERE PRC_EMP_CONFIG.CD_CHAVE = 'ARRED_CINCO_QUARTOS_PED_ELTRONICO'),0)
SET @MEDIAF_MIN = ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG WHERE PRC_EMP_CONFIG.CD_CHAVE = 'MEDIAF_MINIMA_GERACAO_DEMANDA_PEDIDO_ELETRONICO'),-1)

SELECT @CD_FILIAL_DEPOS =(SELECT CD_FILIAL FROM PRC_FILIAL_DEPOSITO WHERE CD_CTR_DEPO =  @CD_CTR_DEPO );
SET @AGORA = CONVERT(CHAR(10),GETDATE(),120);


/******************************************************************************************************************/
-- MONTA ESTRUTURA
/*******************************************************************************************************************/

	
	IF  OBJECT_ID('TEMPDB.DBO.#RSTIPOPRODUTO') IS NOT NULL
	BEGIN
		 DROP TABLE #RSTIPOPRODUTO
	END
	
	IF  OBJECT_ID('tempdb.dbo.#RS_PROD') IS NOT NULL
	BEGIN
		 DROP TABLE #RS_PROD
	END 

	IF  OBJECT_ID('TEMPDB.DBO.#RS_FILIAL') IS NOT NULL
	BEGIN
		 DROP TABLE #RS_FILIAL
	END
	IF  OBJECT_ID('TEMPDB.DBO.#RS_LISTA_PRECO') IS NOT NULL
	BEGIN
		 DROP TABLE #RS_LISTA_PRECO
	END 
	IF  OBJECT_ID('TEMPDB.DBO.#RS_ELTR') IS NOT NULL
	BEGIN
		 DROP TABLE #RS_ELTR
	END
	IF  OBJECT_ID('TEMPDB.DBO.#RS_PROD_CONSOLIDADO') IS NOT NULL
	BEGIN
		 DROP TABLE #RS_PROD_CONSOLIDADO
	END
	IF  OBJECT_ID('TEMPDB.DBO.#RS_FINAL') IS NOT NULL
	BEGIN
		 DROP TABLE #RS_FINAL
	END 

	CREATE TABLE #RSTIPOPRODUTO(TIPOPRODUTO INT) ;


	CREATE TABLE #RS_PROD(  CD_EMP				INT, 
							CD_PROD				INT, 
							FLAG_RESSUPRIMENTO_CAIXA_FECHADA INT,
							QT_UNI_RESSUPRIMENTO MONEY,
							APRES_QT_CP         MONEY
							PRIMARY KEY (CD_PROD,CD_EMP) 
						) 

	CREATE TABLE #RS_FINAL ( CD_USU		INT,
							CD_FILIAL	INT,
							DT_PROC			DATETIME,
							CD_PROD			INT,
							CD_COND_COMPRA	INT,
							QTDE_PROD		MONEY,
							VLR_PROD		MONEY,
							PERC_DESC		MONEY,
							CD_SIGLA	INT, 
							MEDIAF		MONEY,
							QT_EST		MONEY,
							QT_EST_PEND	MONEY,
							QT_EST_MTZ	MONEY,
							MAX_EMAX	MONEY,
							EMAX		MONEY,
							ESEG		MONEY,
							FACE		MONEY,
							FINA		MONEY,
							LIMITADOR	MONEY,
							QT_PEND_ENT	MONEY,
							QT_EST_LOJA MONEY) 

	CREATE TABLE #RS_ELTR ( CD_FILIAL		INT,
									  CD_PROD		INT,
									  EMAX			MONEY,
									  QMIN			MONEY,
									  QTDE_MEDIAF	MONEY,
									  QT_EST		MONEY,
									  QTDE_RESSUP	MONEY, 
									  MEDIAF		MONEY,
									  FLAG_RESSUPRIMENTO_CAIXA_FECHADA	INT,
									  QT_UNI_RESSUPRIMENTO				INT,
									  FLAG_RATEIO				INT,
									  QT_EST_CD_DISP			MONEY,
									  QT_DEMANDA_ABERTO			MONEY
									  PRIMARY KEY (CD_FILIAL,CD_PROD));

	CREATE TABLE #RS_PROD_CONSOLIDADO ( CD_PROD								INT,
												QT_UNI_RESSUPRIMENTO				INT,
												FLAG_RESSUPRIMENTO_CAIXA_FECHADA	INT, 
												QT_EST_FILIAIS_SOMA					MONEY,
												QT_MEDIAF_SOMA						MONEY,
												QT_RESSUP_SOMA						MONEY,
												QT_NECESSIDADE_FILIAIS				MONEY,
												QT_DEPOSITO_INICIO					MONEY,
												QT_DEPOSITO							MONEY,
												FLAG_RATEIO							INT,
												QT_EST_CD_DISP_SOMA				MONEY);
							               			
	CREATE TABLE #RS_FILIAL(    CD_EMP					INT, 
								CD_FILIAL				INT,
								TIPO_PARAMETRO			TINYINT, 
								PRIMARY KEY  (CD_FILIAL , CD_EMP ));  

   
	DELETE FROM RS_ARVMERC_EST_PED_ELTR_DEMANDA_CP_IT WHERE CD_USU = @CD_USU;
/************************************************************************************************************/
-- INICIO DA ROTINA
/************************************************************************************************************/
		
	PRINT 'INICIO DO PROCEDIMENTO ' + CONVERT(VARCHAR,GETDATE(), 108);
		
	--PRODUTO RESSUPRIMENTO
	INSERT INTO #RSTIPOPRODUTO
	SELECT   0

	--PRODUTO SUP-RESSUP
	IF @TIPOPRODUTOCOMPRA = 1
	BEGIN 
	   INSERT INTO #RSTIPOPRODUTO
	   SELECT 2
	END
 
	DELETE 
	FROM EST_PED_ELTR_DEMANDA_CP_TMP
	WHERE
		CD_USU = @CD_USU; 


	IF LEN(RTRIM(LTRIM(@PRODUTOS))) >  0
	BEGIN
		-- CARREGA OS PRODUTOS 
		INSERT INTO #RS_PROD
		SELECT
			P.CD_EMP,
			P.CD_PROD,
			ISNULL(P.FLAG_RESSUPRIMENTO_CAIXA_FECHADA,0),
			ISNULL(P.QT_UNI_RESSUPRIMENTO,1) ,
			CONVERT(MONEY,P.APRES_QT_CP)
			--case when ISNULL(QT_EMB_FECHADA_CP,0) >1 then
			--		QT_EMB_FECHADA_CP 
			--	else CONVERT(MONEY,P.APRES_QT_CP) end
		FROM 
			EST_PROD P  
		WHERE
			P.CD_EMP =@CD_EMP
			AND P.STS_PROD = 0 
			AND P.COMPRA_POR_SUPRIMENTO IN (SELECT TIPOPRODUTO FROM #RSTIPOPRODUTO P) 
			AND P.CD_PROD IN (SELECT ID  FROM UFD_PRM_IN_STRING(@PRODUTOS));     
	END
	ELSE
		BEGIN 
			-- CARREGA OS PRODUTOS 
			INSERT INTO #RS_PROD
			SELECT
				P.CD_EMP,
				P.CD_PROD,
				ISNULL(P.FLAG_RESSUPRIMENTO_CAIXA_FECHADA,0),
				ISNULL(P.QT_UNI_RESSUPRIMENTO,1) , 
				CONVERT(MONEY,P.APRES_QT_CP)
				--case when ISNULL(QT_EMB_FECHADA_CP,0) >1 then
				--	QT_EMB_FECHADA_CP 
				--else CONVERT(MONEY,P.APRES_QT_CP) end
			FROM 
				EST_PROD P  
			WHERE
				P.CD_EMP =@CD_EMP
				AND P.COMPRA_POR_SUPRIMENTO IN (SELECT TIPOPRODUTO FROM #RSTIPOPRODUTO P) 
				AND P.STS_PROD =0 ;     
		END
		
		--Apenas quem tem vinculo com fornecedor
		if @FLAG_IGNORA_VINC_FORN=0
		begin  
			DELETE FROM P
			from
				#RS_PROD P
				LEFT JOIN EST_PROD_FORN F ON
				P.CD_EMP =F.CD_EMP AND
				P.CD_PROD =F.CD_PROD
				AND ISNULL(F.COMPRA_INATIVA,0)=0
			WHERE
				F.CD_EMP IS NULL;
		end


		--Exclui produtos com reposicao pbm
		IF @FLAG_PROD_PBM=1
		BEGIN

		    DELETE FROM A
			FROM 
				#RS_PROD a
				INNER JOIN EST_PROD_RC_CLI_CONV P ON 
				A.CD_EMP	= P.CD_EMP AND
				A.CD_PROD	= P.CD_PROD
			WHERE
				P.CD_EMP = @CD_EMP
				AND P.REPOSICAO   = 'S' 
		END
		 
		Declare @TpParam tinyint 
		set @TpParam = isnull((SELECT valor FROM PRC_EMP_CONFIG WHERE  CD_EMP = 1 AND CD_CHAVE = 'FLAG_USA_NOVO_MODELO_PARAMETROS'
									AND VALOR='1'),0)

		INSERT INTO #RS_FILIAL
		SELECT
			F.CD_EMP,
			F.CD_FILIAL,
			Case When @TpParam = 0 then ISNULL(cfg.VALOR,0)
				 else @TpParam		end TIPO_PARAMETRO
		FROM 
			PRC_FILIAL F  
			LEFT JOIN (SELECT CD_FILIAL , VALOR 
							FROM PRC_FILIAL_CONFIG WHERE  CD_EMP = 1 AND CD_CHAVE = 'FLAG_USA_NOVO_MODELO_PARAMETROS'
									AND VALOR='1') Cfg on 
			f.CD_FILIAL = cfg.CD_FILIAL
		WHERE
			F.CD_EMP =@CD_EMP
			AND F.CD_FILIAL IN (SELECT ID  FROM UFD_PRM_IN_STRING(@FILIAIS))
			AND F.STS_FILIAL =0 ;    
						
						  
		SELECT
			L.CD_COND_COMPRA, 
			L.CD_PROD, 
			L.VLR_PROD, 
			L.PERC_DESC 
		INTO #RS_LISTA_PRECO 
		FROM EST_PROD_PRECO_COND_COMPRA_CPL  L
			INNER JOIN #RS_PROD P ON 
			L.CD_EMP = P.CD_EMP AND
			L.CD_PROD = P.CD_PROD 
		WHERE
			L.CD_EMP=@CD_EMP
			AND L.CD_COND_COMPRA IN  (SELECT ID  FROM UFD_PRM_IN_STRING(@LISTA_PRECO)) ;  
		
	    PRINT 'CARREGOU OS FILTROS ' + CONVERT(VARCHAR,GETDATE(), 108);
		if not exists(select top 1 1 from #RS_PROD) 
			return


		INSERT INTO RS_ARVMERC_EST_PED_ELTR_DEMANDA_CP_IT (CD_EMP,CD_FILIAL,CD_PROD, ESEG,
									EMAX,QTDE_MEDIAP, QT_EST_PEND,QT_PEND_ENT, QT_EST_MTZ,
									CD_GRP_PARAM,CD_SIGLA, VLR_PROD, PERC_DESC,CD_COND_COMPRA,
									APRES_QT_CP, QT_EST_LOJA, CD_USU)
		SELECT
			@CD_EMP,
			ARVMERC.CD_FILIAL,
			ARVMERC.CD_PROD, 
			CASE WHEN @FLAG_PERC_ACIMA = 0 THEN
				ARVMERC.ESEG
			ELSE
				CASE WHEN @FLAG_PERC_ACIMA = 1 THEN  --POR PERCENTUAL
					ARVMERC.ESEG * ((@PERC_ACIMA/100.0000) + 1)
				ELSE --DIA FIXO DE COMPRA
					@PERC_ACIMA
				END
			END,
			CASE WHEN @FLAG_PERC_ACIMA = 0 THEN
				ARVMERC.EMAX
			ELSE
				CASE WHEN @FLAG_PERC_ACIMA = 1 THEN  --POR PERCENTUAL
					ARVMERC.EMAX * ((@PERC_ACIMA/100.0000) + 1)
				ELSE --DIA FIXO DE COMPRA
					@PERC_ACIMA
				END
			END,

			PEND.MEDIAF QTDE_MEDIAP,
			
			--ISNULL(PEND.QT_EST_PEND,0) QT_EST_PEND, --Alterado 
			Case when PEND.QT_EST<0  then  ISNULL(PEND.QT_PEND_ENT,0) - ISNULL(PEND.QT_PEND_SAI,0)  
				 Else ISNULL(PEND.QT_EST_PEND,0) End as QT_EST_PEND,

			ISNULL(PEND.QT_PEND_ENT,0) QT_PEND_ENT,			
			0,
			ARVMERC.CD_GRP_PARAM,
			ARVMERC.CD_SIGLA,  
			ISNULL(LST.VLR_PROD,0)	VLR_PROD,
			ISNULL(LST.PERC_DESC ,0) PERC_DESC ,
			ISNULL(LST.CD_COND_COMPRA,0) CD_COND_COMPRA,
			P.APRES_QT_CP ,
			PEND.QT_EST,
			@CD_USU
		FROM       
			V_EST_PROD_EST_ARV_MERCADOLOGICA ARVMERC 
			INNER JOIN V_EST_PROD_CPL_ESTOQUE_PEDIDO PEND ON 
			ARVMERC.CD_EMP        = PEND.CD_EMP AND
			ARVMERC.CD_FILIAL     = PEND.CD_FILIAL AND
			ARVMERC.CD_PROD       = PEND.CD_PROD 
 
 			INNER JOIN  #RS_FILIAL F ON 
			PEND.CD_EMP        = F.CD_EMP AND
			PEND.CD_FILIAL     = F.CD_FILIAL  
			
			and ARVMERC.TP_GRUPO_PARAMETRO =f.TIPO_PARAMETRO

			INNER JOIN #RS_PROD P ON 
			ARVMERC.CD_EMP  = P.CD_EMP AND 
			ARVMERC.CD_PROD = P.CD_PROD		 

			LEFT JOIN #RS_LISTA_PRECO LST ON  
			ARVMERC.CD_PROD    = LST.CD_PROD   
			
			left JOIN V_PRC_FILIAL_DEPOSITO D ON 
			ARVMERC.CD_EMP       = D.CD_EMP AND
			ARVMERC.CD_FILIAL     = D.CD_FILIAL AND 
			D.CD_CTR_DEPO         = @CD_CTR_DEPO 
		WHERE
			P.CD_EMP=@CD_EMP          
			AND ISNULL(PEND.COMPRA_POR_SUPRIMENTO,0) IN (SELECT TIPOPRODUTO FROM #RSTIPOPRODUTO P) 
			AND PEND.STS_PROD_FILIAL = 0
			;
		
		delete from RS_ARVMERC_EST_PED_ELTR_DEMANDA_CP_IT
			where  QTDE_MEDIAP < @MEDIAF_MIN  ;


		--SELECT * FROM #RS_PROD 
		PRINT 'CARREGOU ARVORE MERCADOLOGICA ' + CONVERT(VARCHAR,GETDATE(), 108);
	 
		--COMPRA POR DIA DE COBERTURA FIXO SOMENTE PARA PRODUTO POR COMPRA POR OL
		IF @FLAG_PERC_ACIMA = 2 
		BEGIN
			   --SOMENTE PRODUTO QUE A COMPRA 
			   --EFETUADA POR OL
			   DELETE
					  R
			   FROM
					  RS_ARVMERC_EST_PED_ELTR_DEMANDA_CP_IT R
			   WHERE
					  NOT EXISTS(SELECT  
										F.CD_EMP
								   FROM
										EST_PROD_FORN F
								   WHERE
										R.CD_EMP = F.CD_EMP AND
										R.CD_PROD = F.CD_PROD AND
										F.COMPRA_OL =1)
					AND R.CD_USU = @CD_USU
		END

		IF @FLAG_PERC_ACIMA = 0
		BEGIN
			----ANALIZANDO SE O PARAMETRO DE MEDIA F POSSUI ALGUM PARAMETRO ESPECIAL
			UPDATE  P
			SET 
				EMAX                     =     ROUND(P.EMAX + ((P.EMAX *  PESP.EMAX)/100.0000),0),
				ESEG                     =     ROUND(P.ESEG + ((P.ESEG *  PESP.ESEG)/100.0000),0)
			FROM         
				EST_ARV_MD_F_GRP_PARAM_ESPECIAIS PESP 
				INNER JOIN RS_ARVMERC_EST_PED_ELTR_DEMANDA_CP_IT P ON
				PESP.CD_EMP           = P.CD_EMP AND
				PESP.CD_GRP_PARAM     = P.CD_GRP_PARAM
			WHERE
				(PESP.FDIAS_ULT_ATU IS NULL
				OR PESP.FDIAS_ULT_ATU <= DATEADD(DAY,- PESP.FDIAS, @AGORA))
				AND (DATEDIFF (DAY, PESP.DT_INICIAL , @AGORA) % PESP.FDIAS) = 0
				AND PESP.DT_INICIAL <=@AGORA
				AND P.CD_USU = @CD_USU;
	 
			----GERANDO AUMENTO DE PERCENTUAL DO EMAX E ESEG POR DATA
			UPDATE P
			SET 
				EMAX                     =     ROUND(P.EMAX + ((P.EMAX *  AUMENT.PERC_AUMENTO)/100.0000),0),
				ESEG                     =     ROUND(P.ESEG + ((P.ESEG *  AUMENT.PERC_AUMENTO)/100.0000),0)
			FROM         
				EST_ARV_GRP_RESSUPRIMENTO_PERC_AUMENTO AUMENT     
				INNER JOIN RS_ARVMERC_EST_PED_ELTR_DEMANDA_CP_IT P ON
				AUMENT.CD_EMP = P.CD_EMP AND
				AUMENT.CD_SIGLA = P.CD_SIGLA
			WHERE
				AUMENT.DT_RESSUP = @AGORA
				AND P.CD_USU = @CD_USU

			----ANALIZANDO SE O PARAMETRO DE MEDIA F POSSUI ALGUM PARAMETRO ESPECIAL POR DIA DA SEMANA
			UPDATE P 
			SET  
				EMAX                     =     PESP.EMAX,
				ESEG                     =     PESP.ESEG
			FROM         
				EST_ARV_MD_F_GRP_PARAM_ESPECIAIS_DIA_SEMANA PESP       
				INNER JOIN RS_ARVMERC_EST_PED_ELTR_DEMANDA_CP_IT P ON
				PESP.CD_EMP = P.CD_EMP AND
				PESP.CD_GRP_PARAM = P.CD_GRP_PARAM
			WHERE
				PESP.DIA_SEMANA = DATEPART(WEEKDAY,@AGORA)
				AND PESP.FLAG_APLICACAO IN (0,2);
		END

		
/**************************************************************************************************************/
-- DEMANDA
/**************************************************************************************************************/

;WITH BASE AS ( SELECT   
					MDF.CD_EMP,   
					MDF.CD_FILIAL, 
					MDF.CD_PROD,  
					DBO.UFD_EST_AJUSTA_EMAX(CASE WHEN @FLAG_CONSIDERA_FACE = 0 THEN 0 ELSE MDF.QTDE_FACEAMENTO END, 
												MDF.VALID_QTDE_FACEAMENTO, MDF.QTDE_FINANCIADO, 
												MDF.QTDE_LIMITADOR, 
												CASE WHEN MDF.QTDE_MEDIAF > 0 THEN 
													CASE WHEN ISNULL(ARVMERC.EMAX,0) > 0 THEN
														ROUND(MDF.QTDE_MEDIAF / 30.0000 * ARVMERC.EMAX, 0)
													ELSE
														0
													END
													 
												ELSE 
													CASE WHEN ISNULL(ARVMERC.EMAX,0) > 0 THEN
														ROUND(ARVMERC.QTDE_MEDIAP / 30.0000 * ARVMERC.EMAX, 0) 
													ELSE
														0
													END
												END) AS EMAX,



														
					DBO.UFD_EST_AJUSTA_ESEG( CASE WHEN @FLAG_CONSIDERA_FACE = 0 THEN 
												0 
											ELSE 
												CASE WHEN ISNULL(MDF.PERC_ESEG_FACEAMENTO,0)=0 THEN
													MDF.QTDE_FACEAMENTO 
												ELSE
													ROUND(MDF.QTDE_FACEAMENTO  * (ISNULL(MDF.PERC_ESEG_FACEAMENTO,0)/100.00),0)
												END
											END, 
												MDF.VALID_QTDE_FACEAMENTO, 
												MDF.QTDE_FINANCIADO, 
												CASE WHEN MDF.QTDE_MEDIAF > 0 THEN 
													ROUND(MDF.QTDE_MEDIAF / 30.0000 * ARVMERC.ESEG, 0) 
												ELSE 
												ROUND(ARVMERC.QTDE_MEDIAP / 30.0000 * ARVMERC.ESEG, 0) END) AS ESEG,			
					CASE WHEN (ARVMERC.QT_EST_PEND + ARVMERC.QT_EST_MTZ) < 0 THEN 
						0
					ELSE 
						ARVMERC.QT_EST_PEND  
					END AS QT_EST,   
					CASE WHEN MDF.QTDE_MEDIAF > 0 THEN 
						MDF.QTDE_MEDIAF 
					ELSE 
						ARVMERC.QTDE_MEDIAP  
					END QTDE_MEDIAF,
					CASE WHEN  ARVMERC.VLR_PROD > 0 THEN 
						ARVMERC.VLR_PROD 
					ELSE
						(SELECT DBO.UFD_EST_PROD_PRECO_TBL(MDF.CD_EMP,MDF.CD_FILIAL,MDF.CD_PROD,1))
					END AS VLR_PROD,
					ARVMERC.EMAX AS EMAX_CAD,
					ARVMERC.ESEG AS ESEG_CAD,
					ARVMERC.QT_EST_PEND,
					ARVMERC.QT_EST_MTZ,
					ARVMERC.CD_SIGLA,
					CASE WHEN @FLAG_CONSIDERA_FACE = 0 THEN 
						0 
					ELSE 
						MDF.QTDE_FACEAMENTO 
					END QTDE_FACEAMENTO, 
					MDF.QTDE_FINANCIADO, 
					MDF.QTDE_LIMITADOR,
					ARVMERC.CD_COND_COMPRA ,
					ARVMERC.PERC_DESC,
					ARVMERC.QT_PEND_ENT,
					ARVMERC.APRES_QT_CP,
					ARVMERC.QT_EST_LOJA  
			FROM         
					EST_PROD_CPL_MEDIAF MDF 
					INNER JOIN RS_ARVMERC_EST_PED_ELTR_DEMANDA_CP_IT ARVMERC ON 
					MDF.CD_EMP        = ARVMERC.CD_EMP AND 
					MDF.CD_FILIAL     = ARVMERC.CD_FILIAL AND
					MDF.CD_PROD       = ARVMERC.CD_PROD
			WHERE
				MDF.CD_EMP=@CD_EMP
				and ARVMERC.CD_USU = @CD_USU )
				 
		INSERT INTO #RS_FINAL
		SELECT         
			@CD_USU,
			B.CD_FILIAL,
			GETDATE(),
			B.CD_PROD, 
			B.CD_COND_COMPRA,
			CASE WHEN ISNULL(RsParEmpresaEmbFornecedor.VALOR,0)=0 THEN
				
				CASE WHEN @UtilizarCincoQuartos =1 THEN
					ROUND( 
							((CASE WHEN B.QT_EST <= 0 THEN
									 ROUND(B.EMAX, 0)
								ELSE
									 ROUND(B.EMAX - B.QT_EST, 0)
								END) / 
								CASE WHEN ISNULL(B.APRES_QT_CP,0)>0 THEN 
									B.APRES_QT_CP
								ELSE
									1
								END )
							,0)  *   B.APRES_QT_CP 
				ELSE

						ceiling ((CASE WHEN B.QT_EST <= 0 THEN
								ROUND(B.EMAX, 0)
							ELSE
								ROUND(B.EMAX - B.QT_EST, 0)
							END)	/ 
							CASE WHEN ISNULL(B.APRES_QT_CP,0)>0 THEN 
								B.APRES_QT_CP
							ELSE
								1
							END)  *   B.APRES_QT_CP 
				END

			ELSE
				CASE WHEN B.QT_EST <= 0 THEN
					 ROUND(B.EMAX, 0)
				ELSE
					 ROUND(B.EMAX - B.QT_EST, 0)
				END
			END AS QTDE_PROD,
			B.VLR_PROD,
			B.PERC_DESC,
			B.CD_SIGLA, 
			B.QTDE_MEDIAF MEDIAF,
			B.QT_EST,
			B.QT_EST_PEND,
		    B.QT_EST_MTZ,
			B.EMAX  MAX_EMAX,
			B.EMAX_CAD EMAX,
			B.ESEG_CAD ESEG,
			B.QTDE_FACEAMENTO FACE,
			B.QTDE_FINANCIADO FINA,
			B.QTDE_LIMITADOR LIMITADOR ,
			B.QT_PEND_ENT,
			B.QT_EST_LOJA			  
		FROM         
			BASE B 			
			INNER JOIN EST_PROD_CURVA_SIGLA S ON 
			B.CD_EMP  = S.CD_EMP AND 
			B.CD_SIGLA = S.CD_SIGLA	 
			INNER JOIN #RS_PROD P ON 
			B.CD_EMP  = P.CD_EMP AND 
			B.CD_PROD = P.CD_PROD
			LEFT OUTER JOIN 
			(SELECT
				CD_EMP,
				VALOR
			FROM
				PRC_EMP_CONFIG
			WHERE
				CD_CHAVE='FLAG_CONVERTER_EMB_RESSUPRIMENTO_FORNECEDOR') RsParEmpresaEmbFornecedor ON
			B.CD_EMP = RsParEmpresaEmbFornecedor.CD_EMP

		WHERE             
			ESEG >= QT_EST 
			AND (CASE WHEN QT_EST <= 0 THEN
						ROUND(EMAX, 0)
					ELSE ROUND(EMAX - QT_EST, 0) END) > 0			
			AND 
			( CASE WHEN (@FLAG_EST_ZERO=0) THEN QT_EST
				ELSE 0 END < 1 ); 
				

	 INSERT INTO   #RS_ELTR (CD_FILIAL,CD_PROD,EMAX,QMIN,
							QTDE_MEDIAF,QT_EST,QTDE_RESSUP, MEDIAF,
							FLAG_RESSUPRIMENTO_CAIXA_FECHADA,
							QT_UNI_RESSUPRIMENTO,FLAG_RATEIO,QT_EST_CD_DISP,QT_DEMANDA_ABERTO)	
	SELECT 
			F.CD_FILIAL,
			F.CD_PROD,
			F.EMAX,
			F.ESEG QMIN,
			F.MEDIAF QTDE_MEDIAF,
			F.QT_EST_PEND QT_EST,
			F.QTDE_PROD QTDE_RESSUP, 
			F.MEDIAF,
			P.FLAG_RESSUPRIMENTO_CAIXA_FECHADA,
			P.QT_UNI_RESSUPRIMENTO,
			0 FLAG_RATEIO,
			CASE WHEN ISNULL(d.CD_EMP,0) =0 THEN 
				0 ELSE F.QTDE_PROD END QT_EST_CD_DISP,
			0 QT_DEMANDA
		FROM
			#RS_FINAL F
			INNER JOIN #RS_PROD P ON 
			F.CD_PROD = P.CD_PROD 
			LEFT JOIN (SELECT 
								CD_EMP,
								CD_PROD,
								SUM((QT_EST + QT_EST_EM_TERC) - QT_PEND_SAI) AS QT_DEPOSITO_INICIO
							FROM
								V_EST_PROD_CPL_ESTOQUE_PEDIDO
							WHERE	
								CD_EMP=@CD_EMP 
								AND CD_FILIAL=@CD_FILIAL_DEPOS 
							GROUP BY
								CD_EMP,
								CD_PROD
							HAVING SUM((QT_EST + QT_EST_EM_TERC) - QT_PEND_SAI) > 0 ) d on 
			F.CD_PROD = d.CD_PROD ;
 
	UPDATE #RS_ELTR SET QTDE_RESSUP =0 WHERE QTDE_RESSUP<1;
	 

/**********************************************************************************************************************/
-- Gerando o estoque da matriz... 
/**********************************************************************************************************************/
	
	Print 'Geracao do picking do estoque do CD - Time ' +convert(varchar,getdate(),108);
 
	IF @FLAG_CONSIDERA_EST_CD=1
	BEGIN
		Print 'Considera estoque do CD - Time ' +convert(varchar,getdate(),108);
 
		WITH FILIAIS AS (SELECT	
							CD_PROD,
							QT_UNI_RESSUPRIMENTO,
							FLAG_RESSUPRIMENTO_CAIXA_FECHADA,
							QT_EST_FILIAIS_SOMA		= SUM(r.QT_EST),
							QT_MEDIAF_SOMA			= SUM(r.QTDE_MEDIAF),
							QT_RESSUP_SOMA			= SUM(ROUND(r.QTDE_RESSUP, 0)),
							QT_NECESSIDADE_FILIAIS	= SUM(case when r.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1 then
																	ROUND((r.QTDE_RESSUP/r.QT_UNI_RESSUPRIMENTO),0)*r.QT_UNI_RESSUPRIMENTO
															else r.QTDE_RESSUP end) 
						FROM 
							#RS_ELTR r
							LEFT JOIN EST_RESSUP_NAO_CONSIDERA_EST_CD_PRC_FILIAL F ON  
							R.CD_FILIAL = F.CD_FILIAL AND 
							F.FLAG_HABILITADO =1
						WHERE
							F.CD_FILIAL IS NULL
						GROUP BY 
							r.CD_PROD, 
							r.QT_UNI_RESSUPRIMENTO,
							r.FLAG_RESSUPRIMENTO_CAIXA_FECHADA),
			DEPOSITO AS (SELECT
								l.CD_PROD,
								SUM((l.QT_EST + l.QT_EST_EM_TERC) - l.QT_PEND_SAI) AS QT_DEPOSITO_INICIO
							FROM
								V_EST_PROD_CPL_ESTOQUE_PEDIDO l
								INNER JOIN #RS_PROD P ON 
								L.CD_EMP = P.CD_EMP AND
								L.CD_PROD = P.CD_PROD 
							WHERE	
								l.CD_EMP=@CD_EMP 
								AND l.CD_FILIAL=@CD_FILIAL_DEPOS 
							GROUP BY
								l.CD_PROD
							HAVING SUM((l.QT_EST + l.QT_EST_EM_TERC) - l.QT_PEND_SAI) > 0 )
	  
		 
		INSERT INTO #RS_PROD_CONSOLIDADO(CD_PROD, QT_UNI_RESSUPRIMENTO,FLAG_RESSUPRIMENTO_CAIXA_FECHADA, 
											QT_EST_FILIAIS_SOMA, QT_MEDIAF_SOMA, QT_RESSUP_SOMA, QT_NECESSIDADE_FILIAIS, 
											QT_DEPOSITO_INICIO, QT_DEPOSITO, FLAG_RATEIO)
		SELECT	
			f.CD_PROD, 
			f.QT_UNI_RESSUPRIMENTO, 
			f.FLAG_RESSUPRIMENTO_CAIXA_FECHADA, 
			f.QT_EST_FILIAIS_SOMA, 
			f.QT_MEDIAF_SOMA, 
			f.QT_RESSUP_SOMA, 
			f.QT_NECESSIDADE_FILIAIS, 		
			CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1 THEN 
				ROUND((d.QT_DEPOSITO_INICIO/f.QT_UNI_RESSUPRIMENTO),0)* f.QT_UNI_RESSUPRIMENTO  
			ELSE d.QT_DEPOSITO_INICIO END QT_DEPOSITO_INICIO,  
			QT_DEPOSITO = (CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1 THEN 
								ROUND((d.QT_DEPOSITO_INICIO/f.QT_UNI_RESSUPRIMENTO),0)* f.QT_UNI_RESSUPRIMENTO  
							ELSE d.QT_DEPOSITO_INICIO END),
			0 FLAG_RATEIO
		FROM 
			FILIAIS f 
			INNER JOIN DEPOSITO d ON 
			d.CD_PROD=f.CD_PROD
		where
			f.QT_RESSUP_SOMA > (CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1 THEN 
								ROUND((d.QT_DEPOSITO_INICIO/f.QT_UNI_RESSUPRIMENTO),0)* f.QT_UNI_RESSUPRIMENTO  
							ELSE d.QT_DEPOSITO_INICIO END) ;
 
		--DELETE FROM #RS_PROD_CONSOLIDADO WHERE QT_DEPOSITO < 1; 
		 
		UPDATE E
		SET	--Necessidade (-) o que tenho no deposito
			QT_EST_CD_DISP = CASE WHEN e.FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1 THEN 
									ROUND((ROUND((E.QTDE_RESSUP/C.QT_RESSUP_SOMA) * QT_DEPOSITO,0)/e.QT_UNI_RESSUPRIMENTO),0)* e.QT_UNI_RESSUPRIMENTO  
								ELSE ROUND((E.QTDE_RESSUP/C.QT_RESSUP_SOMA) * QT_DEPOSITO,0) END,
			E.FLAG_RATEIO=1
		FROM 
			#RS_PROD_CONSOLIDADO  C
			INNER JOIN #RS_ELTR E ON 
			C.CD_PROD = E.CD_PROD
		WHERE 
			QTDE_RESSUP > 0; 
		 
		--Ajusta a soma
		UPDATE s SET  
			QT_RESSUP_SOMA=QTDE_RESSUP,
			QT_DEPOSITO=QT_DEPOSITO_INICIO - QT_EST_CD_DISP,
			QT_EST_CD_DISP_SOMA=QT_EST_CD_DISP,
			FLAG_RATEIO=1
		FROM 
			#RS_PROD_CONSOLIDADO S
			INNER JOIN (SELECT CD_PROD, 
								SUM(QTDE_RESSUP) QTDE_RESSUP , 
								SUM(QT_EST_CD_DISP) QT_EST_CD_DISP
							FROM 
								#RS_ELTR GROUP BY CD_PROD) E ON 
			S.CD_PROD = E.CD_PROD ;
		
		Print 'Inicio do Rateio das quantidades do CD - Time ' +convert(varchar,getdate(),108);
		--Inicio do Rateio das quantidades do CD
		WHILE EXISTS   (SELECT * FROM #RS_PROD_CONSOLIDADO s
							WHERE QT_EST_CD_DISP_SOMA <> QT_DEPOSITO_INICIO)
		begin
	
			WITH BASE AS (SELECT 
								CD_PROD, 
								FATOR_AJUSTE=CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA =1 THEN
												QT_UNI_RESSUPRIMENTO * (case when QT_DEPOSITO_INICIO < QT_EST_CD_DISP_SOMA then -1 else 1 end)
											ELSE SIGN(QT_DEPOSITO_INICIO - QT_EST_CD_DISP_SOMA) END
								FROM 
									#RS_PROD_CONSOLIDADO 
								WHERE QT_EST_CD_DISP_SOMA <> QT_DEPOSITO_INICIO AND FLAG_RATEIO=1)
			UPDATE p 
			SET  
				QT_EST_CD_DISP =  CASE WHEN  QT_EST_CD_DISP + b.FATOR_AJUSTE  > QTDE_RESSUP THEN
										CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA =1 THEN
											CEILING( QTDE_RESSUP/QT_UNI_RESSUPRIMENTO ) *  QT_UNI_RESSUPRIMENTO 
										else	QTDE_RESSUP  end 
									ELSE QT_EST_CD_DISP + b.FATOR_AJUSTE  END,

				FLAG_RATEIO =  CASE WHEN  QT_EST_CD_DISP + b.FATOR_AJUSTE  > QTDE_RESSUP THEN
											0  ELSE 1 END    
			FROM 
				#RS_ELTR p 
				JOIN BASE b ON 
				p.CD_PROD=b.CD_PROD
			WHERE  P.FLAG_RATEIO = 1 AND p.CD_FILIAL = (SELECT	 TOP 1 CD_FILIAL
									FROM 
										#RS_ELTR
									WHERE 
										CD_PROD=b.CD_PROD 
										AND FLAG_RATEIO = 1
									ORDER BY 
										b.FATOR_AJUSTE * (QT_EST_CD_DISP + QT_EST + b.FATOR_AJUSTE) * 30 / CASE WHEN  QTDE_MEDIAF = 0 THEN 
																												.001 ELSE QTDE_MEDIAF END, 
										b.FATOR_AJUSTE * (QT_EST_CD_DISP + QT_EST + b.FATOR_AJUSTE) );
			--Ajusta a soma
			UPDATE s SET   
				QT_EST_CD_DISP_SOMA=QT_EST_CD_DISP 
			FROM 
				#RS_PROD_CONSOLIDADO S
				INNER JOIN (SELECT CD_PROD,   
									SUM(QT_EST_CD_DISP) QT_EST_CD_DISP
								FROM 
									#RS_ELTR GROUP BY CD_PROD) E ON 
				S.CD_PROD = E.CD_PROD and
				QT_EST_CD_DISP_SOMA<>QT_EST_CD_DISP ;
		end   
		
		----Abate as quantidades de estoque que existem no CD
		UPDATE F
		SET 
			QTDE_PROD = R.QTDE_RESSUP -R.QT_EST_CD_DISP , 
			QT_EST_MTZ = R.QT_EST_CD_DISP,
			QT_PEND_ENT = F.QT_PEND_ENT + R.QT_DEMANDA_ABERTO
		FROM 
			#RS_FINAL F 
			INNER JOIN #RS_ELTR R ON
			F.CD_FILIAL  = R.CD_FILIAL AND
			F.CD_PROD  = R.CD_PROD; 	
			 
	end

	----Retirando da demanda produto que nao estao no pedido eletronico
	DELETE FROM F
	FROM 
		#RS_FINAL F 
		LEFT JOIN #RS_ELTR R ON
		F.CD_FILIAL  = R.CD_FILIAL AND
		F.CD_PROD  = R.CD_PROD 
	WHERE R.CD_PROD IS NULL;
	
	/**********************************************************************************************************************/
/**********************************************************************************************************************/
 
	PRINT 'CARREGOU ESTOQUE MATRIZ ' + CONVERT(VARCHAR,GETDATE(), 108);

	INSERT INTO EST_PED_ELTR_DEMANDA_CP_TMP ( CD_USU,CD_FILIAL,DT_PROC,CD_PROD,   CD_COND_COMPRA,QTDE_PROD, 
													VLR_PROD,PERC_DESC,CD_SIGLA,MEDIAF,
													QT_EST,QT_EST_PEND,QT_EST_MTZ,MAX_EMAX,EMAX,ESEG,
													FACE,FINA,LIMITADOR,QT_PEND_ENT)
	SELECT 
		CD_USU,
		CD_FILIAL,
		DT_PROC,
		CD_PROD,   
		CD_COND_COMPRA,
		QTDE_PROD, 
		VLR_PROD,
		PERC_DESC,
		CD_SIGLA,MEDIAF,
		QT_EST_LOJA QT_EST,
		QT_EST_PEND,
		QT_EST_MTZ,
		MAX_EMAX,
		EMAX,
		ESEG,
		FACE,
		FINA,
		LIMITADOR,
		QT_PEND_ENT
	FROM  
		#RS_FINAL;

	PRINT 'GEROU RESULTADO ' + CONVERT(VARCHAR,GETDATE(), 108); 
	exec ('sp_recompile P_EST_PED_ELTR_DEMANDA_CP_IT');